//
//  glass.metal
//  CIGlass
//
//  Created by lrdcq on 2025/6/18.
//

#include <metal_stdlib>
#include <CoreImage/CoreImage.h>
using namespace metal;

extern "C" {
    float3 _linear_to_srgb(float3 linear) {
        return select(
            1.055 * pow(linear, 1.0 / 2.4) - 0.055,
            12.92 * linear,
            linear <= 0.0031308
        );
    }
    
    // 从原始backdrop图像获得像素的能力，获取像素也同时进行一些微调
    float4 _getColorWithOffset(coreimage::sampler source, float2 size, float2 coord, float2 offset) {
        float4 from = sample(source, coord + offset / size);
        float3 rgb = from.rgb;
        //rgb = (rgb - 0.5) * 0.8 + 0.5; // 降低对比度
        rgb *= 1.6; // 增加曝光
        from.rgb = rgb;
        return from;
    }
    
    // 线性映射
    float _linear_map(float x, float y, float a, float b, float tsetnumber) {
        float ratio = (tsetnumber - x) / (y - x);
        return a + ratio * (b - a);
    }
    
    float4 glassProc(coreimage::sampler source, coreimage::sampler sdf, float2 position, float scale, float ref_height, float ref_length) {
        float2 image_size = samplerSize(source);
        float2 sdf_size = samplerSize(sdf);
        float2 coord = samplerCoord(source);
        float2 mark_coord = (coord * image_size - position * scale) / sdf_size;
        
        float4 base_c = _getColorWithOffset(source, image_size, coord, float2(0.0));
        
        if (mark_coord.x < 0.001 || mark_coord.y < 0.001 || mark_coord.x > 0.999 || mark_coord.y > 0.999) {
            return float4(0);
        }
        
        float4 sdf_c = sample(sdf, mark_coord);
        if (base_c.a <=0.01) {
            base_c.a = 0.0;
            return base_c;
        }
        sdf_c.rgb = _linear_to_srgb(sdf_c.rgb); // 兼容一下srgb
        
        if (!(sdf_c.r < 0.99999)) {
            
            base_c.a = 0.0;
            
        } else {
            float dis = (1.0 - sdf_c.r) * 50.0 * scale; // 从sdf解码距离，最大50
            ref_height = ref_height * scale;
            ref_length = ref_length * scale;
            
            if (dis < ref_height) {
                // 第一行，算线性映射，通过distance，算出要取多远的一个点
                float offset = dis - _linear_map(ref_height, 0, ref_height, ref_height - ref_length ,dis);
                
                // 从gb通道解码出向量，这个向量是归一化的（长度为1）
                float2 normal = sdf_c.gb * 2.0 - 1.0; // 方向向量
                normal.y *= -1.0;
                
                // 所以归一化的向量 x 移动距离，就是实际要偏移的像素offset
                float2 offset_normal = normal * offset;
                // 取这个像素
                base_c = _getColorWithOffset(source, image_size, coord, offset_normal);
            }
        }
        return base_c;
    }
}
