//
//  ViewController.m
//  testplay
//

#import "ViewController.h"
#import "Masonry.h"
#import <JavaScriptCore/JavaScriptCore.h>
#import "JscoreBridgeTester.h"

@interface ViewController () <UIWebViewDelegate>

@end


@implementation ViewController {
    UILabel *_lab;
    JscoreBridgeTester *_jstest;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.view.backgroundColor = [UIColor whiteColor];
    
    [NSURLProtocol registerClass:[NSClassFromString(@"BridgeProtocol") class]];
    
    UIWebView *wb = [[UIWebView alloc] init];
    wb.delegate = self;
    [self.view addSubview:wb];
    
    [wb mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self.view);
    }];
    
    [wb loadRequest:[NSURLRequest requestWithURL:[NSURL URLWithString:@"http://127.0.0.1:8080/worktest.html"]]];
}

- (void)webViewDidFinishLoad:(UIWebView *)webView {
    JSContext *ctx = [webView valueForKeyPath:@"documentView.webView.mainFrame.javaScriptContext"];
    _jstest = [JscoreBridgeTester new];
    [_jstest main:ctx];
}
@end
